/* ======== */
/* bjcoef.c */
/* ======== */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <srcrdefs.h>
/* ==================================================================== */
/* BJCoef = calculates correlation coefficient array using Box=Jenkins	*/
/* ==================================================================== */
int
BJCoef(int x[], int NumObs, double Coef[], int NumCoef)
{
    int     RetVal;

    if (NumObs < MIN_VARIATES)
    {
	RetVal = ERROR_MIN_OBS;
    }
    else if (NumCoef < MIN_COEFS)
    {
	RetVal = ERROR_MIN_COEFS;
    }
    else if (NumCoef > MAX_COEFS(NumObs))
    {
	RetVal = ERROR_NUM_COEFS;
    }

    else
    {
	double	Xbar = 0, Xss = 0;
	int	i, i1, j;

	RetVal = OK;

	for (i = 0; i < NumObs; ++i)
	{
	    Xbar += x[i];
	}

	Xbar /= NumObs;

	for (i = 0; i < NumObs; i++)
	{
	    Xss += (x[i] - Xbar) * (x[i] - Xbar);
	}

	if (Xss > 0.0)
	{
	    for (j = 0; j < NumCoef; j++)
	    {
		Coef[j] = 0.0;
		for (i = 0, i1 = j + 1; i1 < NumObs; i++, i1++)
		{
		    Coef[j] += (x[i] - Xbar) * (x[i1] - Xbar);
		}
		Coef[j] /= Xss;
	    }
	}
	else
	{
	    RetVal = ERROR_SOS;
	}
    }

    return RetVal;
}
